##########################################################################
# TPM 2.0 Sample Provisioning Script -- for development systems 
# Copyright Intel Corporation 2015
# Last update: May 8, 2015
# Typically this script is used only during developement to test different Platfrom Policies.
##########################################################################
# Usage                                                                  #
#     SetPlatformPolicy.nsh   <alg>   <fileNamePrefix>                   #
#  Where:                                                                #
#      <alg> is  a supported hash algorithm                              #
#         Such as SHA1, SHA256, SHA384, SHA512, SM3                      #
#         <alg> will be substituted for %1 in Tpm2ProvTool command lines #
#      <fileNamePrefix> is the file name prefix you used to create the   #
#         def files - typically a project name or platform name          #
#        (e.g., MyFirst; Example; Purley)                                #
#         <fileNamePrefix> will be substituted for %2 in command lines   #
#    For example %2PhPolicy%1.hash --> ExamplePhPolicySha256.hash        #
#                %2PhPolicy%1.hash --> MyFirstPhPolicySha384.hash        #
##########################################################################

echo -OFF 
# Copyrights:
# You may copy, distribute, and make derivatives of this script under the 
# following provisions:
#  You must not remove or modify the Intel copyright notice nor these requirements
#  The script must only be used to provision a TPM for use with Intel Technologies
#    For any other use you must get written permission from Intel corporation
 
####################################################################################################################################################
echo Script to set PH Policy > Tpm2SetPlatformPolicy.log
# Assumes that PlatformAuth = Empty so we can use simple PW authorization
echo **** Start PW Session for PlatformAuth 
Tpm2ProvTool StartSession EmptyAuthPwSession.sDef 1 >> Tpm2SetPlatformPolicy.log

# Set PlatformPolicy
echo **** Setting PH Policy
Tpm2ProvTool ImportValue %2PhPolicy%1.hash DIGEST 7 >> Tpm2SetPlatformPolicy.log
Tpm2ProvTool SetPrimaryPolicy SetSavedPhPolicy%1.pSet >> Tpm2SetPlatformPolicy.log
if not %lasterror% == 0 then
	goto ERROR		
endif


:DONE
echo  ***************************************************
echo  ******* Provisioning Completed Successfully *******
echo  ***************************************************

goto EOF

:ERROR
echo  ***************************************************
echo  *************** Provisioning FAILED ***************
echo  ***************************************************
Tpm2ProvTool FlushSession 0 >> Tpm2SetPlatformPolicy.log

goto EOF

:EOF
